<?php
// Initialize variables to store form data and errors
$name = $email = $message = $successMessage = "";
$nameErr = $emailErr = $messageErr = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validate name
    if (empty($_POST["name"])) {
        $nameErr = "Name is required";
    } else {
        $name = htmlspecialchars($_POST["name"]);
    }

    // Validate email
    if (empty($_POST["email"])) {
        $emailErr = "Email is required";
    } elseif (!filter_var($_POST["email"], FILTER_VALIDATE_EMAIL)) {
        $emailErr = "Invalid email format";
    } else {
        $email = htmlspecialchars($_POST["email"]);
    }

    // Validate message
    if (empty($_POST["message"])) {
        $messageErr = "Message is required";
    } else {
        $message = htmlspecialchars($_POST["message"]);
    }

    // Send email if there are no errors
    if (empty($nameErr) && empty($emailErr) && empty($messageErr)) {
        $to = "artur.lomp@voco.ee"; // email kuhu saadetakse
        $subject = "New Contact Form Message";
        $body = "Name: $name\nEmail: $email\n\nMessage:\n$message";
        $headers = "From: $email";

        if (mail($to, $subject, $body, $headers)) {
            $successMessage = "Thank you for contacting us! We will get back to you soon.";
            $name = $email = $message = ""; // Clear the form
        } else {
            $successMessage = "Sorry, there was an error sending your message. Please try again later.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Us</title>
    <link rel="stylesheet" href="style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:ital,wght@0,200..1000;1,200..1000&display=swap" rel="stylesheet">
    <style>
        /* Global styling */
        body {
            font-family: Arial, sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            margin: 0;
            background: #f5f7fa;
        }

        /* Contact container styling */
        .contact-container {
            background-color: #0000003a;
    padding: 30px;
    border-radius: 8px;
    box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
    width: 100%;
    max-width: 400px;
    margin: -50px auto 20px auto; /* Shift container up with negative top margin */
    box-sizing: border-box;
        }

        .contact-container h2 {
            margin-bottom: 1.5rem;
            font-size: 1.8rem;
            color: white;
            text-align: center;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
        }

        /* Form group styling */
        .form-group {
            margin-bottom: 1.2rem;
            text-align: left;
        }

        .form-group label {
            font-weight: normal;
            font-size: 0.9rem;
            color: white;
            display: block;
            margin-bottom: 0.4rem;
        }

        .form-group input, 
        .form-group textarea {
            width: 100%;
            padding: 0.8rem;
            font-size: 1rem;
            border-radius: 8px;
            border: 1px solid #ccc;
            background-color: #f9f9f9;
            transition: border 0.3s;
            box-sizing: border-box;
        }

        .form-group input:focus,
        .form-group textarea:focus {
            border-color: #007bff;
            outline: none;
        }

        .form-group .error {
            color: #e74c3c;
            font-size: 0.8rem;
            margin-top: 0.3rem;
        }

        /* Submit button styling */
        .submit-button {
            width: 100%;
            padding: 0.8rem;
            font-size: 1rem;
            font-weight: normal;
            color: #fff;
            background-color: #007bff;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        .submit-button:hover {
            background-color: #0056b3;
        }

        /* Success message styling */
        .success-message {
            color: #27ae60;
            font-weight: normal;
            margin: 1rem 0;
            font-size: 1.1rem;
            text-align: center;
        }

        /* Responsive styling for mobile */
        @media (max-width: 768px) {

            html, body {
            overflow-x: hidden;
            overflow-y: hidden;
            }

            .contact-container {
                width: 90%; /* Set the container width to 90% for better mobile fit */
                padding: 20px; /* Reduce padding for a compact mobile view */
            }

            .contact-container h2 {
                font-size: 1.5rem; /* Adjust heading size for mobile */
            }

            .submit-button {
                padding: 0.7rem; /* Slightly smaller padding on mobile */
            }
               /* Hamburger icon styles */
       .hamburger {
    display: none;
    cursor: pointer;
    flex-direction: column;
    gap: 5px;
    padding: 10px;
    z-index: 10; /* Make sure the hamburger icon stays above the menu */
    }

    .hamburger .bar {
    width: 25px;
    height: 3px;
    background-color: white;
    transition: 0.4s;
    }

    .nav-links {
        position: fixed;
        top: 0px;
        right: -60%; /* Start off-screen */
        height: 100vh;
        width: 40%; /* Cover half the screen */
        background-color: #000000c7;
        border-left: 0.5px solid white;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        text-align: center;
        transition: right 0.4s ease; /* Smooth slide-in effect */
        z-index: 9; /* Keep the menu below the hamburger icon */
    }

    .nav-links ul {
        flex-direction: column;
        width: 100%;
    }

    .nav-links ul li {
        display: block;
        padding: 15px 0;
        
    }

    /* Show hamburger icon only on mobile */
    .hamburger {
        display: flex;
    }

    /* When active, slide the menu into view */
    .nav-links.active {
        right: -7%;
        }
    
    .hamburger {
        display: flex;
        position: relative; /* Keeps it at the top right of the screen initially */
        right: 10px;
        z-index: 11; /* Above the menu */
    }

    /* Position hamburger icon "inside" menu when it’s open */
    .hamburger.active {
        position: fixed; /* Repositions icon relative to .nav-links */

        right: 10px;
        z-index: 11; /* Above the sliding menu content */
    }
    .Account{
        margin-left: -20px;
        margin-top: 10px;
    }
        }
    </style>
</head>
<body>
<section class="header" id="NavSection">
        <nav class="navbar">
            <a href="Logged.php"><img class="LogoIcon" src="Images/Logo1.png" alt="ArloMusic_Logo"></a>
            
            <div class="hamburger" id="hamburger" onclick="toggleMenu()">
        <div class="bar"></div>
        <div class="bar"></div>
        <div class="bar"></div>
            </div>
            <div class="nav-links" id="navLinks">
            
            <ul>
            <li class="navButton"><a href="index.php">Home</a></li>
            <li class="navButton"><a href="TopPage.php">Top</a></li>
            <li class="navButton"><a href="ArtistsPageNoLog.php">Artists</a></li>
            <li class="navButton"><a href="AccountCreate.php">Sign up</a></li>
            <li class="navButton"><a href="AccountLogin.php">Log in</a></li>
                
            </ul>
            
        </div>
        </nav>
        <div class="HeaderLow">
        <div class="contact-container">
    <h2>Contact Us</h2>
    <?php if (!empty($successMessage)): ?>
        <p class="success-message"><?php echo $successMessage; ?></p>
    <?php endif; ?>
    <form action="contact.php" method="POST">
        <div class="form-group">
            <label for="name">Name:</label>
            <input type="text" id="name" name="name" value="<?php echo $name; ?>" required>
            <div class="error"><?php echo $nameErr; ?></div>
        </div>
        
        <div class="form-group">
            <label for="email">Email:</label>
            <input type="email" id="email" name="email" value="<?php echo $email; ?>" required>
            <div class="error"><?php echo $emailErr; ?></div>
        </div>
        
        <div class="form-group">
            <label for="message">Message:</label>
            <textarea id="message" name="message" rows="4" required><?php echo $message; ?></textarea>
            <div class="error"><?php echo $messageErr; ?></div>
        </div>
        
        <button type="submit" class="submit-button">Send Message</button>
    </form>
</div>
            <br>
        </div>
    </section>
    
    

    <script>
    function toggleMenu() {
        const navLinks = document.getElementById("navLinks");
        navLinks.classList.toggle("active");
        const hamburger = document.getElementById("hamburger");
        hamburger.classList.toggle("active");
    }
</script>
</body>
</html>
